#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Radiant Ember OrbMod01.fsh   by  Tater  
//https://www.shadertoy.com/view/NscSzB
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define rot(a) mat2(cos(a),sin(a),-sin(a),cos(a))
#define pi 3.1415926535
#define pmod(p,x) (mod(p,x)-0.5*(x))

#define elon(p,h) (p-clamp(p,-h,h))

//Enable exit ray
#define refraction2


//iq octohedron
float oct( vec3 p, float s)
{
  p = abs(p);
  float m = p.x+p.y+p.z-s;
  vec3 q;
       if( 3.0*p.x < m ) q = p.xyz;
  else if( 3.0*p.y < m ) q = p.yzx;
  else if( 3.0*p.z < m ) q = p.zxy;
  else return m*0.57735027;
    
  float k = clamp(0.5*(q.z-q.y+s),0.0,s); 
  return length(vec3(q.x,q.y-s+k,q.z-k)); 
}

float box(vec3 p, vec3 b){
    vec3 d = abs(p)-b;
    return max(d.x,max(d.y,d.z));
}

float torus (vec3 p, vec2 b){
  vec2 d = vec2(length(p.yz)-b.x,p.x);
  return length(d)-b.y;
}
float torus2 (vec3 p, vec2 b){
  vec2 d = vec2(length(p.yx)-b.x,p.z);
  return length(d)-b.y;
}
float glow = 0.;
float glow2 = 0.;

bool inside = false;
vec2 map(vec3 p){
    float t= iTime;
    vec3 po2 = p;
    vec2 a = vec2(1.);
    vec2 b = vec2(2.);
    //Swing
    p.y-=7.0;
    p.xy*=rot(sin(t*2.0*pi/3.)*0.28);
    p.y+=7.0;
    vec3 po = p;
    //Glass Displacment
    p+=t*0.2;
    float dis = sin(p.x*5.)*sin(p.y*5.)*sin(p.z*5.)*0.02;
    p = po;
    //Glass ball
    a.x = length(p)-1.0+dis;
    glow2+=0.5/(0.5+a.x*a.x);
    a.x*=0.85;
    if(inside){
        //Octohedron
        p.xz*=rot(t*0.8);
        b.x = oct(p,0.3)-0.02;
        
        //Mini Octohedron
        float s = sign(p.x*p.y*p.z);
        p = abs(p)-0.25+sin(t)*0.05;
        p.xz*=rot(-t*s*2.0);
        b.x = min(b.x, oct(p,0.05)-0.01);

        p = po;
        //Particles
        p.xz*=rot(t);
        p.y-=t;
        float m = 0.5;
        vec3 id = floor(p/m)-0.5;
        p.y+=sin(id.x*id.z)*4.0;

        p = pmod(p,vec3(m));
        b.x*=0.9;
        b.x = min(b.x,length(p));

        b.x = max(a.x,b.x);
        glow+=0.005/(0.001+b.x);

        a.x = max(a.x,-b.x);

        a=(abs(a.x)<abs(b.x))?a:b;
    }
    //chain
    b.y = 3.0;
    float scl = 0.6;
    float m2 = 1.5*scl;
    po.y-=7.5*scl;
    po.xz*=rot(t*0.8);
    p = po;

    p.y = pmod(max(p.y,-m2*4.),m2);
    p.y = elon(p.y,0.3*scl);
    b.x = torus(p,vec2(0.2,0.1)*scl);
    
    p = po;
    p.y+=0.75*scl;
    p.y = pmod(max(p.y,-m2*4.),m2);
    p.y = elon(p.y,0.3*scl);
    b.x = min(b.x,torus2(p,vec2(0.2,0.1)*scl));
    
    a=(abs(a.x)<abs(b.x))?a:b;
    
    if(!inside){
        //Background
        b.y = 4.0;
        p = po2;
        //technique idea taken from yonatan
        for(float s = 1.; s<10.; s/=.55){
            p.xz*=rot(s);
            p.y+=abs(dot(sin(p.xz*s+t*0.8)/s,vec2(0.15)));
            p.y+=(dot(sin(p.xz*s+t*0.4+pi/2.)/s,vec2(0.15)));
        }
        b.x = p.y+1.3;
        b.x*=0.7;

        b.x = max(b.x,(length(p)-9.0));
        a=(a.x<b.x)?a:b;
    }
    return a;
}

vec3 norm(vec3 p){
    vec2 e = vec2(0.001,0);
    return normalize(map(p).x-vec3(
    map(p-e.xyy).x,
    map(p-e.yxy).x,
    map(p-e.yyx).x));
}
#define MDIST 50.0
vec2 march(vec3 ro, vec3 rd, int steps){
    float dO = 0.;
    for(int i = 0; i<steps; i++){
        vec3 p = ro+rd*dO;
        vec2 d = map(p);
        dO+=abs(d.x);
        if(dO>MDIST){
            return vec2(dO,-1.);
        }
        if(abs(d.x)<0.0001||i==steps-1){
            return vec2(dO,d.y);
        }
    }
}

vec3 colorI(vec3 ro, vec3 rd, float dO, float mat){
    vec3 col = vec3(0);
    vec3 p = ro+rd*dO;
    vec3 n = norm(p);
 
    
    vec3 ld = normalize(vec3(1));
    vec3 h = normalize(ld-rd);
    float ndotl = abs(dot( -rd, n ));
    float rim = pow(1.0-ndotl, 5.0);
    float spec = pow(max(dot(n,h),0.0),5.0);
    
    
    vec3 bg = vec3(0.3);
    if(mat==1.0) col = bg;
    
    col+=rim;
    
    float dens = 0.1;
    vec3 gemCol = vec3(0.310,0.004,0.396);
    vec3 coloredDens = (1.-log(gemCol))*dens;
    vec3 optDist = exp(-dO*coloredDens);
    
    //float optDist = exp(-dO*dens);
    col = mix(gemCol,col,optDist);

    col = col*optDist*gemCol;
    
    if(mat==2.0)glow*=rim;
    col+=clamp(glow*0.5,0.,2.0)*vec3(0.886,0.376,0.129);
    
    
    return col;
}
bool refracted = false;
vec3 colorO(vec3 ro, vec3 rd, float dO, float mat){
    vec3 col = vec3(0);
    vec3 p = ro+rd*dO;
    vec3 n = norm(p);
    vec3 ld = normalize(vec3(1));
    vec3 h = normalize(ld-rd);
    vec3 r = reflect(rd,n);
    float ndotl = abs(dot( -rd, n ));
    float rim = pow(1.0-ndotl, 3.0);
    float spec = length(sin(r*2.)*.5+.5)/sqrt(3.);
    
    vec3 bg = vec3(0.);
    col = mix(col,bg,1.0);
    //col+=clamp(glow*0.3,0.,0.8)*vec3(0.886,0.376,0.129);
    if(dO<MDIST&&mat!=4.0){
        col+=pow(spec,4.0)*3.0*vec3(1,0,0);
        col+=rim*5.0;
    }
    
    col+=clamp(glow2*0.03,0.,2.0)*vec3(0.886,0.376,0.129);
    if(refracted) col=glow2*rim*vec3(0.886,0.376,0.129)*0.1;
    return col;
}
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    vec2 uv = (fragCoord-0.5*iResolution.xy)/iResolution.y;
	vec2 m = iMouse.xy/iResolution.xy;

    vec3 col = vec3(0);
    m.y+=0.1;
    vec3 ro = vec3(0,0.5+m.y*5.0,-4.0-m.y*10.0);
    
    //ro.yz *= rot(-m.y*3.14+1.);
    ro.xz *= rot(-m.x*6.2831);
    
    vec3 lk = vec3(0,0.3,0);
    vec3 f = normalize(lk-ro);
    vec3 r = normalize(cross(vec3(0,1,0),f));
    vec3 rd = normalize(f*0.99+uv.x*r+uv.y*cross(f,r));
    vec2 dO = vec2(0);
    vec3 rdo = rd;
    //Index of Refraction
    float ior = 1.4;
    
    dO = march(ro,rd,170);
    vec3 p = ro+rd*dO.x;
    //Yeah this lighting setup is janky but it looks better than how I intended it
    //so I'm keeping it 
    col = colorO(ro,rd,dO.x,dO.y); //Color the outside
    
    //If hit the glass then march into it and color the inside
    if(dO.y==1.0||dO.y==3.0){
        inside = true; //optimize which geometry to check
        glow = 0.;
        ro = p;
        vec3 n = norm(p);
        ro-=n*0.05;
        rd = refract(rd,n,1./ior);
        if(dO.y==1.0)dO = march(ro,rd,90);
        col = mix(col,colorI(ro,rd,dO.x,dO.y),0.9);
        
        //attempted reflection on the surface, might re-visit
        /* 
        inside = false; //optimize which geometry to check
        glow = 0.;
        glow2 = 0.;
        vec2 dO2 = vec2(0);
        dO2 = march(p+n*0.05,reflect(rd,n),90);
        refracted = true;
        vec3 col2 = colorO(ro,rd,dO2.x,dO2.y);
        float fres = pow(1.0-abs(dot(-rdo, n)),1.0);
        col+=col2*fres;
        */

    #ifdef refraction2
        if(dO.y==1.0){
            inside = false; //optimize which geometry to check
            refracted = true; //janky fix to make the background more defined
            p =ro+rd*dO.x;
            glow = 0.;
            glow2 = 0.;
            ro = p;
            n = norm(p);
            ro += n*0.05;
            vec3 ref = refract(rd,-n,ior);
            if(ref == vec3(0)) rd = reflect(rd,-n);
            else rd = ref;
            
            //not accurate but maybe more visually apealing ray direction
            //rd = rdo; 
            
            dO = march(ro,rd,40);
            
            col = mix(col,colorO(ro,rd,dO.x,dO.y),0.1);    
        }
    #endif     

    }

    fragColor = vec4(col,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

